/*
 * Routines for dealing with the FMS settings table
 */

#include "db.h"
#include "libfma.h"
#include "lf_internal.h"
#include "lf_db.h"
#define _LF_DEFINE_TABLES_
#include "lf_fms_settings.h"

/*
 * Open the FMS settings table, creating it if necessary
 */
db_table_ptr_t
lf_open_fms_settings_table(
  db_database_ptr_t dbp,
  int **colids)
{
  db_table_ptr_t tp;
  int rc;
  int col;
  char *col_names[LF_TABLE_FMS_SETTINGS_NUMCOLS];
  db_datum_type_t col_types[LF_TABLE_FMS_SETTINGS_NUMCOLS];
  int *cip;

  /* array for column translation */
  LF_CALLOC(cip, int, LF_TABLE_FMS_SETTINGS_NUMCOLS);

  /*
   * try just opening the table.  if successful, return the pointer!
   */
  tp = db_open_table(dbp, LF_TABLE_FMS_SETTINGS);
  if (tp != NULL) {
    /* get the column indices */
    rc = lf_get_column_indices(tp,
                             lf_table_fms_settings_cols,
			     LF_TABLE_FMS_SETTINGS_NUMCOLS,
			     cip,
			     LF_TABLE_FMS_SETTINGS);
    *colids = cip;
    return tp;
  }

  /*
   * Can't open it.  OK, let's create it.
   */

  /* fill in names and types */
  for (col=0; col<LF_TABLE_FMS_SETTINGS_NUMCOLS; ++col) {
    col_names[col] = lf_table_fms_settings_cols[col].col_name;
    col_types[col] = lf_table_fms_settings_cols[col].col_type;

    /* column indices are identity since we created it that way */
    cip[col] = col;
  }

  /* create the table */
  rc = db_create_table(dbp, LF_TABLE_FMS_SETTINGS,
                             LF_TABLE_FMS_SETTINGS_NUMCOLS,
			     col_names, col_types);
  if (rc != 0) LF_ERROR(("Error creating FMS settings table"));

  /* try once more to open it */
  tp = db_open_table(dbp, LF_TABLE_FMS_SETTINGS);
  if (tp == NULL) LF_ERROR(("Error opening FMS settings table"));

  *colids = cip;
  return tp;

 except:
  LF_FREE(cip);
  *colids = NULL;
  return NULL;
}
